#define F_CPU 16000000UL 		        // ???? ????????? (16 MHz)




#include <avr/pgmspace.h>

unsigned char EEPROM_read(unsigned int uiAddress)
{
while(EECR & (1<<EEWE));//  EEWE
EEAR = uiAddress;//  
EECR |= (1<<EERE);// 
return EEDR;//    
}


unsigned char SPI_transmit(unsigned char data)
{
// Start transmission
SPDR = data;
// Wait for transmission complete
while(!(SPSR & (1<<SPIF)));
data = SPDR;

return(data);
}


void EEPROM_write(unsigned int uiAddress, unsigned char ucData)
{
while(EECR & (1<<EEWE));//   EEWE
EEAR = uiAddress;// 
EEDR = ucData;//  
EECR |= (1<<EEMWE);// EEMWE
EECR |= (1<<EEWE);// EEWE
}


void main ()
{
	//  
	PORTB = 0xFF;
	DDRB  = 0xBF; //MISO line i/p, rest o/p
	//  SPI init
	SPCR = (1<<MSTR)|(1<<SPE); // SPI config
	SPSR=(1<<SPI2X); // double speed

EEPROM_write(0,0x15);
SPI_transmit(0x55);
SPI_transmit(0x55);
SPI_transmit(0x55);
SPI_transmit(0x55);
SPI_transmit(0x55);
SPI_transmit(0x55);
SPI_transmit(0x55);
EEPROM_write(1,0x77);
while(1){}
}
